var Colors = new Object();
Colors.Normal = CreateColor(255, 255, 255);
Colors.White = CreateColor(255, 255, 255);
Colors.Blue = CreateColor(0, 150, 240);
Colors.Yellow = CreateColor(253, 176, 23);
Colors.YellowS = CreateColor(253, 176, 23, 100);
Colors.Rust = CreateColor(128, 128, 106);
Colors.Grayed = CreateColor(184, 184, 184);
Colors.Red = CreateColor(200, 0, 0);
Colors.Cyan = CreateColor(0, 160, 198);
Colors.CyanS = CreateColor(0, 160, 198, 100);
Colors.Shadow = CreateColor(0, 0, 0, 100);
Colors.WShadow = CreateColor(255, 255, 255, 100);
Colors.Black = CreateColor(0, 0, 0);

var Images = new Object();
Images.Gauge = LoadImage("Gauge.png");

function WindowFunctions()
{
	this.border = LoadWindowStyle("BWindow.rws");
	this.nborder = LoadWindowStyle("Window.rws");
}

WindowFunctions.prototype.drawWindow = function(x, y, w, h, border, heading)
{
	if (border == undefined || border == true)
	{
		this.border.drawWindow(x, y, w, h);
	}
	if (border == false)
	{
		this.nborder.drawWindow(x, y, w, h);
	}
	if (heading != undefined)
	{
		font.heading.drawText(x-5, y-5, heading);
	}
}

WindowFunctions.prototype.battleWindow = function(x, y, character)
{
	var tcharacter = Game.party[character];
	font.drawText(x, y, tcharacter.name);
	font.drawText(x+68, y, tcharacter.hp, "right");
	font.drawText(x+68, y, "/"+tcharacter.mp);
	Gauge(x+92, y, 44, tcharacter.sta, 1000, Colors.Blue, Colors.Shadow);
}

WindowFunctions.prototype.partyWindow = function(x, y, character)
{
	window.drawWindow(x+7, y+1, 106, 28, true, "STATUS");
	font.drawText(x+5, y+3, character.name);
	font.drawText(x+5, y+13, "LV");
	font.drawText(x+30, y+13, character.lv, "right");
	font.drawText(x+5, y+23, "HP");
	font.drawText(x+36, y+23, character.hp, "right");
	font.drawText(x+36, y+23, "/"+character.maxhp);
	font.drawText(x+62, y+23, "MP");
	font.drawText(x+94, y+23, character.mp, "right");
	font.drawText(x+94, y+23, "/"+character.maxmp);
	font.drawText(x+62, y+3, "Next LV");
	font.drawText(x+117, y+13, 0 + "p", "right");
}

WindowFunctions.prototype.message = function(x, y, w, speaker, text, freeze, time)
{
	if (Game.messageopen == false)
	{
		if (freeze == true)
			Game.control = true;
		Game.messageopen = true;
		Game.messagex = x;
		Game.messagey = y;
		Game.messagew = w;
		Game.messagespeaker = speaker;
		Game.messagetext = text;
		Game.messageletter = 0;
		BindKey(Game.accept, "MessageAccept()", "");
		if (time == 0)
			Game.messagetime = false;
		else
			Game.messagetime = GetTime() + time;
	}
}

WindowFunctions.prototype.drawMessage = function()
{
	window.drawWindow(Game.messagex, Game.messagey+4, Game.messagew, Math.floor(font.font.getStringWidth(Game.messagetext.substr(0, Game.messageletter)) / Game.messagew) * 9);
	font.drawTextBox(Game.messagex+5, Game.messagey, Game.messagew, Math.floor(font.font.getStringWidth(Game.messagetext) / Game.messagew) * 9 + 9, Game.messagetext.substr(0, Game.messageletter));
	if (Game.messageletter < Game.messagetext.length)
		Game.messageletter++;
	if (Game.messageletter > Game.messagetext.length)
		Game.messageletter = Game.messagetext.length;
}

var window = new WindowFunctions();

function FontFunctions()
{
	this.font = LoadFont("Main.rfn");
	this.title = LoadFont("Title.rfn");
	this.heading = LoadFont("Little.rfn");
	this.drawText = function(x, y, text, alignment, color)
	{
		if (color == undefined)
			color = Colors.Normal;
		if (alignment == undefined)
			alignment = "left";
		var xplus = 0;
		if (alignment == "center")
			xplus = Math.floor(this.font.getStringWidth(text) / 2);
		if (alignment == "right")
			xplus = this.font.getStringWidth(text);
		this.font.setColorMask(Colors.Shadow);
		this.font.drawText(x - xplus + 1, y + 1, text);
		this.font.setColorMask(color);
		this.font.drawText(x - xplus, y, text);
	}
	this.drawTextBox = function(x, y, w, h, text)
	{
		this.font.setColorMask(Colors.Shadow);
		this.font.drawTextBox(x + 1, y + 1, w, h, 0, text);
		this.font.setColorMask(Colors.Normal);
		this.font.drawTextBox(x, y, w, h, 0, text);
	}
}

var font = new FontFunctions();

function MapScript()
{
	if (Game.menuopen == true)
	{
		Game.currentmenu.execute(Game.currentmenu.x, Game.currentmenu.y, Game.currentmenu.w, Game.currentmenu.h);
	}
	if (Game.messageopen == true)
	{
		window.drawWindow(Game.messagex, Game.messagey+4, Game.messagew, Math.floor(font.font.getStringWidth(Game.messagetext.substr(0, Game.messageletter)) / Game.messagew) * 9);
		font.drawTextBox(Game.messagex+5, Game.messagey, Game.messagew, Math.floor(font.font.getStringWidth(Game.messagetext) / Game.messagew) * 9 + 9, Game.messagetext.substr(0, Game.messageletter));
		if (Game.messageletter < Game.messagetext.length)
			Game.messageletter++;
		if (Game.messageletter > Game.messagetext.length)
			Game.messageletter = Game.messagetext.length;
		if (Game.messagetime != false)
		{
			if (GetTime() >= Game.messagetime)
				Game.messageopen = false;
		}
		if (Game.messagetime == false && Game.messageletter >= Game.messagetext.length)
		{
			var tx = Game.messagex + Game.messagew - 5;
			var ty = Game.messagey + Math.floor(font.font.getStringWidth(Game.messagetext) / Game.messagew) * 9;
			Triangle(tx, ty, tx+7, ty, tx+4, ty+8, Colors.Red); // Replace with icon or something
		}
	}
	if (Game.area == true)
	{
		font.drawText(159 - (font.font.getStringWidth(Game.areatext) / 2), 100, Game.areatext);
		var person = GetInputPerson();
		if (GetPersonX(person) < Game.areax - 16 || GetPersonX(person) > Game.areax + 16 || GetPersonY(person) < Game.areay - 16 || GetPersonY(person) > Game.areay + 16)
		{
			Game.area = false;
			Game.areatext = "";
			Game.areamap = "";
		}
	}
}

function ShowArea(text, amap)
{
	Game.area = true;
	Game.areatext = text;
	Game.areax = GetPersonX(GetInputPerson());
	Game.areay = GetPersonY(GetInputPerson());
	Game.areamap = amap;
}

function MessageAccept()
{
	if (Game.messagetime == false)
	{
		if (Game.messageletter == Game.messagetext.length)
			Game.messageopen = false;
	}
}

function DrawCursor(x, y)
{
	Images.Selector.blit(x - Images.Selector.width - 2, y);
}

function Gauge(x, y, l, var1, var2, clr1, clr2)
{
	var glength = Math.floor(var1 * (l-1) / var2);
	Line(x, y, x+l, y, Colors.Shadow);
	Line(x, y+1, x, y+7, Colors.Shadow);
	Line(x+1, y+7, x+l, y+7, Colors.WShadow);
	Line(x+l, y+1, x+l, y+6, Colors.WShadow);
	if (glength > 0)
	{
		GradientLine(x+1, y+1, x+glength, y+1, clr1, clr2);
		GradientLine(x+1, y+2, x+glength, y+2, clr1, clr2);
		GradientLine(x+1, y+3, x+glength, y+3, clr1, clr2);
		GradientLine(x+1, y+4, x+glength, y+4, clr1, clr2);
		GradientLine(x+1, y+5, x+glength, y+5, clr1, clr2);
		GradientLine(x+1, y+6, x+glength, y+6, clr1, clr2);
	}
}